/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jmx.test;

import org.jboss.test.JBossTestCase;
import org.jboss.test.jmx.invokerproxy.MyServiceMBean;
import org.jboss.test.jmx.invokerproxy.IProxy;
import junit.framework.Test;

import javax.naming.InitialContext;

/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class JMXInvokerProxyUnitTestCase
   extends JBossTestCase
{
   public JMXInvokerProxyUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite()
      throws Exception
   {
      return getDeploySetup(JMXInvokerProxyUnitTestCase.class, "invoker-proxy-test.sar");
   }

   public void testInvokeTargetMethod() throws Exception
   {
      InitialContext ic = new InitialContext();
      MyServiceMBean myService = (MyServiceMBean)ic.lookup("MyServiceInvokeTarget");
      final String arg = "myAction";
      String result = myService.myAction(arg);
      assertEquals(arg, result);
   }

   public void testInvoke() throws Exception
   {
      InitialContext ic = new InitialContext();
      MyServiceMBean myService = (MyServiceMBean)ic.lookup("MyService");
      final String arg = "invoke";
      String result = myService.myAction(arg);
      assertEquals(arg, result);
   }

   public void testProgramaticProxy() throws Exception
   {
      InitialContext ic = new InitialContext();
      IProxy myService = (IProxy) ic.lookup("IProxy");
      String result = myService.echoDate("testProgramaticProxy");
      assertTrue(result, result.indexOf("testProgramaticProxy") >= 0);
   }
}
