/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.jmx.interceptors;

import java.security.Principal;
import org.jboss.mx.interceptor.AbstractInterceptor;
import org.jboss.mx.server.Invocation;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;

/** An interceptor that simply asserts the caller is jduke
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public final class PrincipalInterceptor
   extends AbstractInterceptor
{
   private static Logger log = Logger.getLogger(PrincipalInterceptor.class);

   // Interceptor overrides -----------------------------------------
   public Object invoke(Invocation invocation) throws Throwable
   {
      /* Allow access to the getMBeanInfo since this is bbean is deployed
      but not accessed in non-secure tests (JMXInvokerUnitTestCase).
      */
      String type = invocation.getType();
      if( type != Invocation.OP_GETMBEANINFO )
      {
         Principal caller = SecurityAssociation.getPrincipal();
         String opName = invocation.getName();
         log.info("invoke, opName="+opName+", caller="+caller);
         if( caller == null || caller.getName().equals("jduke") == false )
         {
            throw new SecurityException("Caller="+caller+" is not jduke");
         }
      }
      return invocation.nextInterceptor().invoke(invocation);
   }
}
