/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jca.test;

import org.jboss.test.JBossTestCase;
import org.jboss.test.jca.interfaces.HAConnectionSessionHome;
import org.jboss.resource.adapter.jdbc.local.HALocalManagedConnectionFactory;

import java.io.File;
import java.util.Arrays;

import junit.framework.Test;


/**
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision:1$</tt>
 */
public class HAConnectionFactoryUnitTestCase
   extends JBossTestCase
{
   /**
    * Constructor for the JBossTestCase object
    *
    * @param name Test case name
    */
   public HAConnectionFactoryUnitTestCase(String name)
   {
      super(name);
   }

   public static Test suite() throws Exception
   {
      // this is for deploying the ha rar which is not deployed by default
      // FIXME: is there a better way to do it?
      String connectorLib = System.getProperty("jbosstest.deploy.dir") + "/../../../connector/output/lib/";

      Test t;
      t = getDeploySetup(HAConnectionFactoryUnitTestCase.class, "jcatest.jar");
      t = getDeploySetup(t, "jbosstestadapter.jar");
      t = getDeploySetup(t, "test-ha-ds.xml");
      t = getDeploySetup(t, "test-ha-xa-ds.xml");
      t = getDeploySetup(t, new File(connectorLib + "jboss-ha-local-jdbc.rar").toURL().toString());
      t = getDeploySetup(t, new File(connectorLib + "jboss-ha-xa-jdbc.rar").toURL().toString());
      return t;
   }

   public void testFailoverLocalMCF() throws Exception
   {
      HAConnectionSessionHome home = (HAConnectionSessionHome)getInitialContext().lookup("HAConnectionSession");
      home.create().testHaLocalConnection();
   }

   public void testFailoverXaMCF() throws Exception
   {
      HAConnectionSessionHome home = (HAConnectionSessionHome)getInitialContext().lookup("HAConnectionSession");
      home.create().testHaXaConnection();
   }

   public void testURLSelector() throws Exception
   {
      Object[] urls = new Object[]{"url1", "url2", "url3"};
      HALocalManagedConnectionFactory.URLSelector selector = new HALocalManagedConnectionFactory.URLSelector(
         Arrays.asList(urls)
      );

      String url = selector.getUrl();
      assertEquals(urls[0], url);
      url = selector.getUrl();
      assertEquals(urls[0], url);
      url = selector.getUrl();
      assertEquals(urls[0], url);

      selector.failedUrl(url);
      url = selector.getUrl();
      assertEquals(urls[1], url);
      url = selector.getUrl();
      assertEquals(urls[1], url);

      selector.failedUrl(url);
      url = selector.getUrl();
      assertEquals(urls[2], url);
      url = selector.getUrl();
      assertEquals(urls[2], url);

      for(int i = 0; i < 10; ++i)
      {
         selector.failedUrl(url);
         url = selector.getUrl();
         assertEquals(urls[i % 3], url);
      }
   }
}
