/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jca.inflow;

import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkManager;

/**
 * Management interface of TestResourceAdapter.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class TestResourceAdapterWorkManager
{
   TestResourceAdapter adapter;
   public TestResourceAdapterWorkManager(TestResourceAdapter adapter)
   {
      this.adapter = adapter;
   }
   
   public TestResourceAdapterWorkManagerResults run() throws Exception
   {
      TestResourceAdapterWorkManagerResults results = new TestResourceAdapterWorkManagerResults();
      try
      {
         basicTest();
         results.basicTest.pass();
      }
      catch (Throwable t)
      {
         results.basicTest.fail(t);
      }

      return results;
   }
   
   public void basicTest() throws Exception
   {
      WorkManager wm = adapter.ctx.getWorkManager();
      TestWork work = new TestWork(); 
      wm.doWork(work);
      if (work.complete == false)
         throw new Exception("Work was not done");
   }
   
   public class TestWork implements Work
   {
      public boolean complete = false;

      public void run()
      {
         complete = true;
      }

      public void release()
      {
      }
   }
}
