/*
 * JBoss, the OpenSource J2EE webOS
 * 
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jca.inflow;

import javax.resource.spi.endpoint.MessageEndpoint;

/**
 * Management interface of TestResourceAdapter.
 * 
 * @author <a href="adrian@jboss.com">Adrian Brock</a>
 * @version $Revision:1$
 */
public class TestResourceAdapterInflow
{
   TestResourceAdapter adapter;
   public TestResourceAdapterInflow(TestResourceAdapter adapter)
   {
      this.adapter = adapter;
   }
   
   public TestResourceAdapterInflowResults run() throws Exception
   {
      TestResourceAdapterInflowResults results = new TestResourceAdapterInflowResults();
      try
      {
         basicTest();
         results.basicTest.pass();
      }
      catch (Throwable t)
      {
         results.basicTest.fail(t);
      }

      return results;
   }
   
   public void basicTest() throws Exception
   {
      MessageEndpoint endpoint = adapter.getEndpoint("testInflow");
      if (endpoint == null)
         throw new Exception("Null endpoint");
      TestMessage message = new TestMessage();
      ((TestMessageListener) endpoint).deliverMessage(message);
      if (message.acknowledged == false)
         throw new Exception("MDB did not acknowledge the message");
   }
}
