/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
 
package org.jboss.test.jbossnet.security.server;

import org.jboss.test.util.ejb.SessionSupport;

/**
 * Non-secured session bean to test web service authorization. 
 * @author jung
 * @version $Revision:1$
 * @ejb.bean name="Authorization"
 *           display-name="Authorization Bean"
 *           type="Stateless"
 *           view-type="remote"
 *           jndi-name="security/Authorization"
 * @ejb.interface remote-class="org.jboss.test.jbossnet.security.Authorization" extends="javax.ejb.EJBObject"
 * @ejb.home remote-class="org.jboss.test.jbossnet.security.AuthorizationHome" extends="javax.ejb.EJBHome"
 * @ejb.transaction type="Required"
 * @ejb.permission unchecked="true"
 * @jboss-net.web-service urn="Authorization"
 * @jboss-net.authentication domain="jbossnet-tests"
 * @jboss-net.authorization domain="jbossnet-tests" roles-allowed="Role2, Role1" roles-denied="Role3"
 */

public class AuthorizationBean
   extends SessionSupport implements javax.ejb.SessionBean
{
   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */
   
   public boolean workedOut()
   {
      // return true if role1 is logged in
      return sessionCtx.getCallerPrincipal().getName().equals("jduke");
   }

}
