/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jbossmx.compliance.notcompliant;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

import org.jboss.test.jbossmx.compliance.TestCase;
import org.jboss.test.jbossmx.compliance.notcompliant.support.DynamicAndStandard;
import org.jboss.test.jbossmx.compliance.notcompliant.support.OverloadedAttribute1;
import org.jboss.test.jbossmx.compliance.notcompliant.support.OverloadedAttribute2;
import org.jboss.test.jbossmx.compliance.notcompliant.support.OverloadedAttribute3;

public class NCMBeanTestCase
   extends TestCase
{
   public NCMBeanTestCase(String s)
   {
      super(s);
   }

   public void testOverloadedAttribute1()
   {
      registerAndTest(new OverloadedAttribute1(), true);
   }

   public void testOverloadedAttribute2()
   {
      // according to spec this is not a problem
      registerAndTest(new OverloadedAttribute2(), false);
   }

   public void testOverloadedAttribute3()
   {
      registerAndTest(new OverloadedAttribute3(), true);
   }

   public void testMixedDynamicStandard()
   {
      // according to the spec this is not a problem any more
      registerAndTest(new DynamicAndStandard(), false);
   }

   public void testNoConstructor()
   {
      registerAndTest(new NoConstructor(), true);
   }

   private void registerAndTest(Object mbean, boolean shouldFail)
   {
      try
      {
         MBeanServer server = MBeanServerFactory.newMBeanServer();
         server.registerMBean(mbean, new ObjectName("test:foo=bar"));
         if (shouldFail)
            fail("expected a NotCompliantMBeanException for " + mbean.getClass().getName());
      }
      catch (NotCompliantMBeanException e)
      {
         if (shouldFail == false)
            fail("NotCompliantMBeanException for " + mbean.getClass().getName());
      }
      catch (Exception e)
      {
         fail("unexpected exception when registering " + mbean.getClass().getName() + ": " + e.getMessage());
      }
   }
}
