/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jbossmq.test;

import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSubscriber;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.Session;
import javax.management.ObjectName;
import javax.naming.Context;

import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.test.JBossTestCase;

/**
 * A test to make sure topic subscriptions are tidied up correctly
 *
 * @author <a href="mailto:adrian@jboss.org>Adrian Brock</a>
 * @version <tt>$Revision:1$</tt>
 */
public class CleanTopicRemovalUnitTestCase extends JBossTestCase
{
   static String TOPIC_FACTORY = "ConnectionFactory";
   static ObjectName destinationManager = ObjectNameFactory.create("jboss.mq:service=DestinationManager");
   static ObjectName messageCache = ObjectNameFactory.create("jboss.mq:service=MessageCache");
   
   TopicConnection topicConnection;
   Topic topic;
   
   public CleanTopicRemovalUnitTestCase(String name) throws Exception
   {
      super(name);
   }

   public void testCleanTopicRemoval() throws Throwable
   {
      createTopic();
      try
      {
         connect();
         try
         {
            TopicSession session = topicConnection.createTopicSession(false, Session.AUTO_ACKNOWLEDGE);
            TopicPublisher publisher = session.createPublisher(topic);
            TopicSubscriber receiver1 = session.createSubscriber(topic);
            topicConnection.start();

            getLog().debug("Publish message");
            Message message = session.createMessage();
            publisher.publish(message);
            
            int beforeCacheCount = getCacheCount();
            getLog().debug("beforeCacheCount=" + beforeCacheCount);
            
            removeTopic();
            
            int afterCacheCount = getCacheCount();
            getLog().debug("afterCacheCount=" + afterCacheCount);
           
            assertEquals("Message should be removed ", afterCacheCount, beforeCacheCount - 1);
         }
         finally
         {
            disconnect();
         }
      }
      catch (Throwable t)
      {
         try
         {
            getLog().error("Error ", t);
            removeTopic();
         }
         catch (Throwable ignored)
         {
         }
         throw t;
      }
   }

   protected void connect() throws Exception
   {
      Context context = getInitialContext();
      TopicConnectionFactory topicFactory = (TopicConnectionFactory) context.lookup(TOPIC_FACTORY);
      topicConnection = topicFactory.createTopicConnection();

      getLog().debug("Connection established.");
   }

   protected void disconnect()
   {
      try
      {
         if (topicConnection != null)
            topicConnection.close();
      }
      catch (Throwable ignored)
      {
         getLog().warn("Ignored", ignored);
      }

      getLog().debug("Connection closed.");
   }

   protected void createTopic() throws Exception
   {
      getLog().debug("Create topic");
      RMIAdaptor server = getServer();
      server.invoke(destinationManager, "createTopic",
         new Object[]
         {
            "cleanTopicRemovalTest",
            "topic/cleanTopicRemovalTest"
         },
         new String[]
         {
            String.class.getName(),
            String.class.getName()
         }
      );
      Context context = getInitialContext();
      topic = (Topic) context.lookup("topic/cleanTopicRemovalTest");
      
      log.debug("Got topic " + topic);
   }

   protected void removeTopic() throws Exception
   {
      getLog().debug("Remove topic");
      RMIAdaptor server = getServer();
      server.invoke(destinationManager, "destroyTopic",
         new Object[]
         {
            "cleanTopicRemovalTest",
         },
         new String[]
         {
            String.class.getName()
         }
      );
   }

   protected int getCacheCount() throws Exception
   {
      RMIAdaptor server = getServer();
      Integer cacheCount = (Integer) server.getAttribute(messageCache, "TotalCacheSize");
      return cacheCount.intValue();
   }
}

