/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.iiopperf.interfaces;

/** 
 * A serializable data object for testing data passed to an EJB.
 * This data object defines a writeObject method (which means that 
 * the corresponding IDL valuetype is custom-marshaled).
 */
public class CMFoo implements java.io.Serializable
{
   public int i;
   public String s;
   
   public CMFoo(int i, String s)
   {
      this.i = i;
      this.s = s;
   }
   
   public String toString()
   {
      return "CMFoo(" + i + ", \"" + s + "\")";
   }
   
   public boolean equals(Object o)
   {
      return (o instanceof CMFoo) && (((CMFoo)o).i == i)
                                && (((CMFoo)o).s.equals(s));
   }
   
   private synchronized void writeObject(java.io.ObjectOutputStream s)
      throws java.io.IOException {
      s.defaultWriteObject();
   }
}
