/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.hibernate.ejb.interfaces;

/**
 * Utility class for ProfileService.
 */
public class ProfileServiceUtil
{

   private static Object lookupHome(java.util.Hashtable environment, String jndiName, Class narrowTo) throws javax.naming.NamingException {
      // Obtain initial context
      javax.naming.InitialContext initialContext = new javax.naming.InitialContext(environment);
      try {
         Object objRef = initialContext.lookup(jndiName);
         // only narrow if necessary
         if (narrowTo.isInstance(java.rmi.Remote.class))
            return javax.rmi.PortableRemoteObject.narrow(objRef, narrowTo);
         else
            return objRef;
      } finally {
         initialContext.close();
      }
   }

   // Home interface lookup methods

   /**
    * Obtain remote home interface from default initial context
    * @return Home interface for ProfileService. Lookup using JNDI_NAME
    */
   public static org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome getHome() throws javax.naming.NamingException
   {
         return (org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome) lookupHome(null, org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome.JNDI_NAME, org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome.class);
   }

   /**
    * Obtain remote home interface from parameterised initial context
    * @param environment Parameters to use for creating initial context
    * @return Home interface for ProfileService. Lookup using JNDI_NAME
    */
   public static org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome getHome( java.util.Hashtable environment ) throws javax.naming.NamingException
   {
       return (org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome) lookupHome(environment, org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome.JNDI_NAME, org.jboss.test.hibernate.ejb.interfaces.ProfileServiceHome.class);
   }

}