/*
 * JBoss, the OpenSource webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cts.ejb;

import javax.ejb.MessageDrivenBean;
import javax.ejb.MessageDrivenContext;
import javax.jms.MessageListener;
import javax.jms.Message;
import javax.jms.TextMessage;

/** Test of signature validation across inheritence hiearchy
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public abstract class AbstractMDB implements MessageListener, MessageDrivenBean
{
   public void onMessage(Message message)
   {
      if( message instanceof TextMessage )
      {
         TextMessage tm = (TextMessage) message;
         onTextMessage(tm);
      }
   }

   public void setMessageDrivenContext(MessageDrivenContext ctx)
   {  
   }

   public void ejbCreate()
   {
   }

   public void ejbRemove()
   {
   }

   public abstract void onTextMessage(TextMessage tm);
}
