/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.test.cmp2.optimisticlock.bug1006723.testsession;


import org.jboss.test.cmp2.optimisticlock.bug1006723.testentity.EntityALocal;
import org.jboss.test.cmp2.optimisticlock.bug1006723.testentity.EntityBLocal;
import org.jboss.test.cmp2.optimisticlock.bug1006723.testentity.EntityBLocalHome;
import org.jboss.test.cmp2.optimisticlock.bug1006723.testentity.EntityALocalHome;

import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import java.util.Iterator;
import java.util.Date;

public class TestSessionBean implements SessionBean{

	public Long setup() throws Exception{
		try{		
			/* Add an entity A and then add some entity Bs to it. */
			EntityALocal entityA = getEntityALocalHome().create(new Long(1));
			entityA.addEntityB(getEntityBLocalHome().create(new Long(2)));
			return entityA.getOID();
		}
		catch (Exception e){
			sessionContext.setRollbackOnly();
			throw e;
		}
	}

	public void test(Long entityAOID) throws Exception{
		try{
			EntityALocal entityA = getEntityALocalHome().findByPrimaryKey
				(entityAOID);
			Iterator entityBs = entityA.listEntityBs().iterator();
			while (entityBs.hasNext()){
				((EntityBLocal)entityBs.next()).setLastModified(new Date());
			}
		}
		catch (Exception e){
			sessionContext.setRollbackOnly();
			throw e;
		}
	}

	public void ejbCreate() throws CreateException{}

	public void ejbRemove(){}

	public void ejbActivate(){}

	public void ejbPassivate(){}

	public void setSessionContext(SessionContext context){
		this.sessionContext = context;
	}

	private Context getContext(){
		if (context == null){
			try{
				context = new InitialContext();
			}
			catch (NamingException e){
				throw new EJBException(e.getMessage());
			}
		}
		return context;
	}

	private EntityALocalHome getEntityALocalHome(){
		if (entityALocalHome == null){
			try{
				entityALocalHome = (EntityALocalHome)getContext().lookup
					("java:comp/env/ejb/EntityA");
			}
			catch (NamingException e){
				throw new EJBException(e.getMessage());
			}
		}
		return entityALocalHome;
	}

	private EntityBLocalHome getEntityBLocalHome(){
		if (entityBLocalHome == null){
			try{
				entityBLocalHome = (EntityBLocalHome)getContext().lookup
					("java:comp/env/ejb/EntityB");
			}
			catch (NamingException e){
				throw new EJBException(e.getMessage());
			}
		}
		return entityBLocalHome;
	}

	private SessionContext sessionContext;
	private Context context;
	private EntityALocalHome entityALocalHome;
	private EntityBLocalHome entityBLocalHome;

}

