/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.test;

import junit.framework.Test;
import org.apache.commons.httpclient.HttpClient;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Simple clustering test case of get/set.
 *
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class SimpleTestCase
      extends BaseTest
{

   public SimpleTestCase(String name)
   {
      super(name);

   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(SimpleTestCase.class,
            "http-sr.war");
      return t1;
   }

   /**
    * Main method that deals with the Http Session Replication Test
    *
    * @throws Exception
    */
   public void testHttpSessionReplication()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testHttpSessionReplication");

      String setURLName = "/http-sr/testsessionreplication.jsp";
      String getURLName = "/http-sr/getattribute.jsp";

      getLog().debug(setURLName + ":::::::" + getURLName);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      makeGet(client, baseURL0_ +setURLName);

      // Get the Attribute set by testsessionreplication.jsp
      attr = makeGetWithState(client, baseURL0_ +getURLName);

      sleepThread(200);

      // Let's switch to server 2 to retrieve the session attribute.
      setCookieDomainToThisServer(client, servers_[1]);
      String attr2 = makeGet(client, baseURL1_ +getURLName);

      // Check the result
      assertEquals("Http session replication attribtues retrieved from both servers ", attr, attr2);

      getLog().debug("Http Session Replication has happened");
      getLog().debug("Exit testHttpSessionReplication");
   }

   public void testSessionTimeout()
      throws Exception
   {
      String attr = "";
      getLog().debug("Enter testSessionTimeout");

      String setURLName = "/http-sr/testsessionreplication.jsp";
      String getURLName = "/http-sr/getattribute.jsp";

      getLog().debug(setURLName + ":::::::" + getURLName);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      makeGet(client, baseURL0_ +setURLName);

      // Get the Attribute set by testsessionreplication.jsp
      attr = makeGetWithState(client, baseURL0_ +getURLName);
      assertNotNull("Http session get", attr);
      sleepThread(65000);  // sleep for 65 seconds for session to expire
      attr = makeGetWithState(client, baseURL0_ +getURLName);
      assertNull("Http session get", attr);
   }

}
