/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cluster.test;

import junit.framework.Test;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.test.JBossClusteredTestCase;

/**
 * Clustering test case of get/set under scoped class loader.
 *
 * @author Ben Wang
 * @version $Revision: 1.0
 */
public class ScopedTestCase
      extends BaseTest
{
   protected String setUrl;
   protected String getUrl;
   protected String modifyUrl;
   protected String invalidateUrl;

   public ScopedTestCase(String name)
   {
      super(name);
      setUrl = "/http-scoped/setSession.jsp";
      getUrl = "/http-scoped/getAttribute.jsp";
      modifyUrl = "/http-scoped/modifyAttribute.jsp";
      invalidateUrl = "/http-scoped/invalidateSession.jsp";
   }

   public static Test suite() throws Exception
   {
      Test t1 = JBossClusteredTestCase.getDeploySetup(ScopedTestCase.class,
            "http-scoped.war");
      return t1;
   }

   /**
    * Main method that deals with the Http Session Replication Test
    *
    * @throws Exception
    */
   public void testNonPrimitiveGet()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testNonPrimitiveGet");

      getLog().debug(setUrl + ":::::::" + getUrl);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      makeGet(client, baseURL0_ +setUrl);

      // Create a method instance.
      // Get the Attribute set
      attr = makeGet(client, baseURL0_ +getUrl);

      sleepThread(200);

      // Make connection to server 1 and get
      setCookieDomainToThisServer(client, servers_[1]);
      String attr2 = makeGet(client, baseURL1_ +getUrl);

      assertEquals("Get attribute should be but is ", attr, attr2);
      getLog().debug("Exit testNonPrimitiveGet");
   }

   /**
    * Test session modify with non-primitive get/modify.
    *
    * @throws Exception
    */
   public void testNonPrimitiveModify()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testNonPrimitiveModify");

      getLog().debug(setUrl + ":::::::" + getUrl);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      makeGet(client, baseURL0_ +setUrl);

      // Get the Attribute set
      String attrOld = makeGet(client, baseURL0_ +getUrl);

      // Modify a method instance.
      makeGet(client, baseURL0_ +modifyUrl);

      // Get the Attribute set
      attr = makeGet(client, baseURL0_ +getUrl);

      sleepThread(200);

      // Make connection to server 1 and get
      setCookieDomainToThisServer(client, servers_[1]);
      String attr2 = makeGet(client, baseURL1_ +getUrl);

      // Check the result
      assertNotSame("Old attribute should be different from new one.",
            attrOld, attr);
      assertEquals("Attributes should be the same", attr, attr2);
      getLog().debug("Exit testNonPrimitiveModify");
   }

   /**
    * Test invalidate session
    *
    * @throws Exception
    */
   public void testInvalidate()
         throws Exception
   {
      String attr = "";
      getLog().debug("Enter testInvalidate");

      getLog().debug(setUrl + ":::::::" + getUrl);

      // Create an instance of HttpClient.
      HttpClient client = new HttpClient();

      // Set the session attribute first
      makeGet(client, baseURL0_ +setUrl);

      // Get the Attribute set
      String attrOld = makeGet(client, baseURL0_ +getUrl);

      // Invalidate the Attribute set
      makeGet(client, baseURL0_ +invalidateUrl);

      sleepThread(200);

      // Make connection to server 1 and get
      // Make connection to server 1 and get
      setCookieDomainToThisServer(client, servers_[1]);
      // Session is invlaidated. Should have not OK response.
      makeGetFailed(client, baseURL1_ +getUrl);

      getLog().debug("Exit testInvalidate");
   }


}
