/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cluster.ejb;

import java.rmi.RemoteException;
import java.rmi.dgc.VMID;
import javax.ejb.EJBObject;

/** The interface for the ejb called by the test client
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface CalledRemote
   extends EJBObject
{
   /**
    * Invoke CalleeRemote.call("invokeCall")
    * @return VMID[0 == localhost], [1 == remotehost]
    * @param jndiURL
    * @param jndiName - 
    * @throws RemoteException
    */ 
   public VMID[] invokeCall(String jndiURL, String jndiName)
      throws RemoteException;
}
