/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.classloader.scoping.naming.service;

import java.io.Serializable;

/** A custom serializable object stored in jndi and accessed by two different
 * class loading scopes to test marshalling of jndi lookups.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class BindValue implements Serializable
{
   static final long serialVersionUID = 7241841260062493619L;
   private String value;

   public String getValue()
   {
      return value;
   }
   public void setValue(String value)
   {
      this.value = value;
   }
}
