/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.standAloneAop;

/**
 * Object to test non-primitive key.
 */
public class ValueObject {

  private IdObject idObj;
  private float value;

  public ValueObject() {
  } // ValueObject

  public ValueObject(IdObject aIdObj, float aValue) {
    idObj = aIdObj;
    value = aValue;
  } // ValueObject

  public IdObject getIdObj() {
    return idObj;
  }

  public float getValue() {
    return value;
  }

  public String toString() {
    return idObj + ": " + value;
  } // toString

  public boolean equals(Object aObject) {
    boolean result = false;

    if ((aObject != null) &&
         (aObject.getClass().getName().equals( this.getClass().getName()))) {
      result = idObj.equals(((ValueObject)aObject).idObj);
    } // if

    return result;
  } // equals

  public int hashCode() {
    return idObj.hashCode();
  } // hashCode
} // class ValueObject
