/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;
import org.jboss.cache.aop.CachedMapInterceptor;
import org.jboss.cache.aop.TreeCacheAop;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.aop.proxy.ClassProxy;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;


/**
 * ObjectTestCase.java that uses standalone aop package. Test simple get put Object
 *
 * @author Ben Wang
 */

public class NonAspectizedAopTest extends TestCase
{
   Logger log_ = Logger.getLogger(NonAspectizedAopTest.class);
   TreeCacheAop cache_;

   public NonAspectizedAopTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log_.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      cache_ = new TreeCacheAop();
      PropertyConfigurator config = new PropertyConfigurator();
      config.configure(cache_, configFile); // read in generic replSync xml
      cache_.start();
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      cache_.stop();
   }

//   public void testDummy() {}

   public void testPutPrimitive() throws Exception
   {
      log_.info("testPutPrimitive() ....");
      String test = "test";
      cache_.putObject("/a", test);
      String result = (String)cache_.getObject("/a");
      assertEquals("test string ", "test", result);
      cache_.removeObject("/a");
      assertNull("Object should be null ", cache_.getObject("/a"));
   }

   public void testPutSerializable() throws Exception
   {
      log_.info("testPutSerializable() ....");
      SerializedAddress test = new SerializedAddress();
      test.setCity("Sunnyvale");
      test.setZip(94086);
      cache_.putObject("/a", test);
      SerializedAddress result = (SerializedAddress)cache_.getObject("/a");
      assertEquals("test SerializedAddress ", test, result);
      cache_.removeObject("/a");
      assertNull("Object should be null ", cache_.getObject("/a"));
   }

   public static Test suite() throws Exception
   {
      return new TestSuite(NonAspectizedAopTest.class);
   }


   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

}

