/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.standAloneAop;

/**
 * Key object that overrides the hashCode that can cause problem for aop.
 */
public class IdObject{

  private String id;

  public IdObject()  {
  } // IdObject

  public IdObject(String aId)  {
    id = aId;
  } // IdObject


  public String toString()  {
    return id;
  } // toString

  public boolean equals(Object aObject)  {
    boolean result = false;

    if ((aObject != null) &&
         (aObject.getClass().getName().equals( this.getClass().getName()))) {
      if (id.equals(((IdObject)aObject).id)) {
        result = true;
      } // if
    } // if

    return result;
  } // equals

  public int hashCode()  {
    return id.hashCode();
  } // hashCode
} // class IdObject

