/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.standAloneAop;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.logging.Logger;

import java.util.*;

//import org.jboss.test.JBossTestCase;


/**
 * List interface testing.
 */

public class CachedListAopTest extends TestCase
{
   Logger log = Logger.getLogger(CachedListAopTest.class);
   TreeCacheAopTester tester;
   List languages;


   public CachedListAopTest(String name)
   {
      super(name);
   }

   protected void setUp() throws Exception
   {
      super.setUp();
      log.info("setUp() ....");
      String configFile = "META-INF/local-service.xml";
      tester = new TreeCacheAopTester(configFile);

      tester.createPerson("/person/test6", "p6", 50);
      tester.addLanguage("/person/test6", "German");
      tester.addLanguage("/person/test6", "English");
      tester.addLanguage("/person/test6", "French");
      languages = (List)tester.getLanguages("/person/test6");
   }

   protected void tearDown() throws Exception
   {
      super.tearDown();
      tester.stop();
      tester = null;
   }

   public void testAddAndRemoveIndex() throws Throwable
   {
      int size = tester.getLanguagesSize("/person/test6");
      assertTrue(size == 3);
      languages.add(1, "Taiwanese");
      size = tester.getLanguagesSize("/person/test6");
      assertEquals("Languages size ", 4, size);
      String language = (String) tester.getLanguage("/person/test6", 1);
      assertEquals("Language ", (Object)"Taiwanese", (Object)language);
      languages.remove(1);
      size = tester.getLanguagesSize("/person/test6");
      assertEquals("Languages size ", 3, size);

      languages.add("Mandarin");
      size = tester.getLanguagesSize("/person/test6");
      assertEquals("Languages size ", 4, size);
      languages.remove("Mandarin");
      size = tester.getLanguagesSize("/person/test6");
      assertEquals("Languages size ", 3, size);
   }

   public void testAddAllAndClear() throws Throwable
   {
      int size = tester.getLanguagesSize("/person/test6");
      assertTrue(size == 3);

      List list = new ArrayList();
      list.add("Taiwanese");
      list.add("Madarin");

      assertTrue("Language is Taiwanese ", list.contains("Taiwanese"));

      languages.addAll(list);
      size = tester.getLanguagesSize("/person/test6");
      assertEquals("Languages size ", 5, size);

      languages.removeAll(list);
      size = tester.getLanguagesSize("/person/test6");
      assertEquals("Languages size ", 3, size);

      assertEquals("Index of Taiwanese ", 1, languages.indexOf("English"));

      languages.clear();
      size = tester.getLanguagesSize("/person/test6");
      assertEquals("Languages size ", 0, size);

      assertTrue("Languages empty ", languages.isEmpty());
   }

   public void testEquals() throws Throwable {
      List list = (List)tester.getLanguages("/person/test6");
      assertTrue("List should be the same ", list.equals(languages));
      list = new ArrayList();
      list.add("German");
      list.add("test");
      list.add("English");
      assertFalse("List should not be the same ", languages.equals(list));
      assertFalse("List should not be the same ", list.equals(languages));
   }

   public void testIterator() {
      Iterator it = languages.iterator();
      int counter = 0;
      while(it.hasNext()) {
         counter++;
         it.next();
         it.remove();
      }

      assertEquals("Size should be ", 3, counter);
      assertEquals("Skills should be empty ", 0, languages.size());
   }

   public void testListIterator() {
      ListIterator li = languages.listIterator();
      assertFalse("LI has no previous element ", li.hasPrevious());
      assertTrue("LI has next element ", li.hasNext());
      li.next();
      assertEquals("Index is ", 1, li.nextIndex());
      assertEquals("Index is ", 0, li.previousIndex());
      li.next();
      li.next(); // the end
      try {
         li.next();
         fail("Should throw an exception here ");
      }
      catch (NoSuchElementException ex) {
         ;
      }
      assertEquals("Index is ", 3, li.nextIndex());
      assertEquals("Index is ", 2, li.previousIndex());
      li.previous();
      assertEquals("Index is ", 2, li.nextIndex());
      assertEquals("Index is ", 1, li.previousIndex());
      li.previous();
      li.previous();
      try {
         li.previous();
         fail("Should throw an exception here ");
      }
      catch (NoSuchElementException ex) {
         ;
      }
   }

   public static Test suite() throws Exception
   {
      return new TestSuite(CachedListAopTest.class);
   }

   public static void main(String[] args) throws Exception
   {
      junit.textui.TestRunner.run(suite());
   }

}

