/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.cache.test.generic;


import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.TreeCache;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Set;


/**
 * @author <a href="mailto:bela@jboss.org">Bela Ban</a>
 * @version $Id:GetKeysTestCase.java,v 1.0, 2005-06-24 19:04:45Z, Robert Worsnop$
 */
public class GetKeysTestCase extends TestCase {
   TreeCache cache;

   public GetKeysTestCase(String s) {
      super(s);
   }

   public void setUp() throws Exception {
      super.setUp();
   }

   public void tearDown() throws Exception {
      super.tearDown();
   }

   public void testGetKeys() throws Exception {
      cache=new TreeCache();
      cache.createService();
      cache.startService();
      cache.put("/a/b/c", "name", "Bela Ban");
      cache.put("/a/b/c", "age", new Integer(40));
      cache.put("/a/b/c", "city", "Kreuzlingen");

      Set keys=cache.getKeys("/a/b/c");
      log("keys are " + keys);
      assertNotNull(keys);
      assertEquals(3, keys.size());

      ByteArrayOutputStream outstream=new ByteArrayOutputStream(20);
      ObjectOutputStream out=new ObjectOutputStream(outstream);
      out.writeObject(keys); // must be serializable
   }

   public void testGetChildren() throws Exception {
      cache=new TreeCache();
      cache.createService();
      cache.startService();
      cache.put("/a/b/c", null);
      cache.put("/a/b/c/1", null);
      cache.put("/a/b/c/2", null);
      cache.put("/a/b/c/3", null);

      Set children=cache.getChildrenNames("/a/b/c");
      log("children are " + children);
      assertNotNull(children);
      assertEquals(3, children.size());

      ByteArrayOutputStream outstream=new ByteArrayOutputStream(20);
      ObjectOutputStream out=new ObjectOutputStream(outstream);
      out.writeObject(children); // must be serializable
   }


   void log(String msg) {
      System.out.println("-- " + msg);
   }

   public static Test suite() {
      return new TestSuite(GetKeysTestCase.class);
   }

   public static void main(String[] args) {
      junit.textui.TestRunner.run(suite());
   }

}
