/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.test.cache.test.eviction;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.cache.Fqn;
import org.jboss.cache.PropertyConfigurator;
import org.jboss.cache.TreeCache;

/**
 * @author Ben Wang, Feb 11, 2004
 */
public class ReplicatedLRUPolicyUnitTestCase extends TestCase
{
   TreeCache cache_, cache1_, cache2_;
   int wakeupIntervalMillis_ = 0;

   public ReplicatedLRUPolicyUnitTestCase(String s)
   {
      super(s);
   }

   public void setUp() throws Exception
   {
      super.setUp();
      cache_ = new TreeCache();
      initCaches(cache_);
//      cache1_ = new TreeCache();
//      initCaches(cache1_);
      cache_.startService();
//      cache1_.startService();
      // cache2 doesn't have eviction policy
      cache2_ = new TreeCache();
      PropertyConfigurator config = new PropertyConfigurator();
      config.configure(cache2_, "META-INF/replSync-service.xml"); // read in generic local xml
      cache2_.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
      cache2_.startService();

      wakeupIntervalMillis_ = cache_.getEvictionThreadWakeupIntervalSeconds() *1000;
      log("wakeupInterval is " +wakeupIntervalMillis_);
      if(wakeupIntervalMillis_ <=0)
         fail("testEviction(): eviction thread wake up interval is illegal " +wakeupIntervalMillis_);
   }

   void initCaches(TreeCache cache) throws Exception
   {
      PropertyConfigurator config = new PropertyConfigurator();
      config.configure(cache, "META-INF/replSync-eviction-service.xml"); // read in generic local xml
      cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
   }

   public void tearDown() throws Exception
   {
      super.tearDown();
      cache_.stopService();
      cache2_.stopService();
   }

   /**
    * Test local eviction policy
    */
   public void testEviction() {
      String rootStr = "/org/jboss/test/data/";
      for(int i=0; i < 10; i++) {
         String str = rootStr +i;
         Fqn fqn = Fqn.fromString(str);
         try {
            cache_.put(fqn, str, str);
         } catch (Exception e) {
            fail("Failed to insert data" +e);
            e.printStackTrace();
         }
      }

      _sleep(2 *wakeupIntervalMillis_);
      try {
         String val = (String)cache_.get(rootStr +"3", rootStr+"3");
         assertNull("Node should be evicted already ", val);
         val = (String)cache2_.get(rootStr +"3", rootStr+"3");
         assertNotNull("Node should not be evicted here ", val);
      } catch (Exception e) {
         e.printStackTrace();
      }
   }

   public void testEvictionReplication() {
      String rootStr = "/org/jboss/test/data/";
      for(int i=0; i < 10; i++) {
         String str = rootStr +i;
         Fqn fqn = Fqn.fromString(str);
         try {
            cache_.put(fqn, str, str);
         } catch (Exception e) {
            fail("Failed to insert data" +e);
            e.printStackTrace();
         }
      }

      _sleep(wakeupIntervalMillis_ -1000);
      String str = rootStr +"7";
      Fqn fqn = Fqn.fromString(str);
      try {
         cache_.get(fqn, str);
      } catch (Exception e) {
         fail("Failed to get data. Exception: " +e);
      }
      _sleep(wakeupIntervalMillis_);

      try {
         String val = (String)cache_.get(rootStr +"3", rootStr+"3");
         assertNull("Node should be empty ", val);
         val = (String)cache2_.get(rootStr +"7", rootStr+"7");
         assertNotNull("Node should not be null", val);
      } catch (Exception e) {

         e.printStackTrace();
      }
   }

   void _sleep(long msecs) {
      try {
         Thread.sleep(msecs);
      } catch (InterruptedException e) {
         e.printStackTrace();  //To change body of catch statement use File | Settings | File Templates.
      }
   }
   void log(String msg)
   {
      System.out.println("-- " + msg);
   }

   public static Test suite()
   {
      return new TestSuite(ReplicatedLRUPolicyUnitTestCase.class);
   }

   public static void main(String[] args)
   {
      junit.textui.TestRunner.run(suite());
   }

}
