/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.bankiiop.ejb;

import java.io.ObjectStreamException;
import java.rmi.RemoteException;
import javax.ejb.CreateException;

import org.jboss.test.bankiiop.interfaces.AccountData;
import org.jboss.test.bankiiop.interfaces.Customer;

/**
 *      
 *   @author Rickard Oberg
 *   @author $Author:Robert Worsnop$
 *   @version $Revision:1$
 */
public class AccountBeanCMP
   extends AccountBean
{
   // Constants -----------------------------------------------------
    
   // Attributes ----------------------------------------------------
   public String id;
   public float balance;
   public Customer owner;
   
   private boolean dirty;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   public String getId()
   {
      return id;
   }
   
   public void setId(String id)
   {
      this.id = id;
      dirty = true;
   }
   
   public float getBalance()
   {
      return balance;
   }
   
   public void setBalance(float balance)
   {
      this.balance = balance;
      dirty = true;
   }
   
   public Customer getOwner()
   {
      return owner;
   }
   
   public void setOwner(Customer owner)
   {
      this.owner = owner;
      dirty = true;
   }
   
   public void setData(AccountData data)
   {
      setBalance(data.getBalance());
      setOwner(data.getOwner());
   }
   
   public AccountData getData()
   {
      AccountData data = new AccountData();
      data.setId(id);
      data.setBalance(balance);
      data.setOwner(owner);
      return data;
   }
   
   public boolean isModified()
   {
      return dirty;
   }
   
   // EntityBean implementation -------------------------------------
   public String ejbCreate(AccountData data) 
      throws RemoteException, CreateException
   { 
      setId(data.id);
      setData(data);
      dirty = false;
      return null;
   }
   
   public void ejbPostCreate(AccountData data) 
      throws RemoteException, CreateException
   { 
   }
   
   public void ejbLoad()
      throws RemoteException
   {
      super.ejbLoad();
      dirty = false;
   }
}

/*
 *   $Id:AccountBeanCMP.java,v 1.0, 2005-06-24 18:43:38Z, Robert Worsnop$
 *   Currently locked by:$Locker:$
 *   Revision:
 *   $Log:
 *    1    Main      1.0         6/24/2005 2:43:38 PM   Robert Worsnop  
 *   $
 *   Revision 1.1.26.1  2005/04/06 16:28:03  starksm
 *   Fix the license header
 *
 *   Revision 1.1  2002/03/15 22:36:28  reverbel
 *   Initial version of the bank test for JBoss/IIOP.
 *
 *   Revision 1.2  2001/01/07 23:14:34  peter
 *   Trying to get JAAS to work within test suite.
 *
 *   Revision 1.1.1.1  2000/06/21 15:52:37  oberg
 *   Initial import of jBoss test. This module contains CTS tests, some simple examples, and small bean suites.
 *
 *
 *  
 */
