/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.bank.ejb;

import java.rmi.RemoteException;
import javax.ejb.CreateException;

import org.jboss.test.util.ejb.EntitySupport;
import org.jboss.test.bank.interfaces.Customer;

/**
 *      
 *   @author Rickard Oberg
 *   @author $Author:Robert Worsnop$
 *   @version $Revision:1$
 */
public abstract class AccountBean
   extends EntitySupport
{
   // Constants -----------------------------------------------------
    
   // Attributes ----------------------------------------------------
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------
   public void deposit(float amount)
   {
      setBalance(getBalance()+amount);
   }
   
   public void withdraw(float amount)
   {
      setBalance(getBalance()-amount);
   }

   public abstract float getBalance();
   public abstract void setBalance(float balance);
}

/*
 *   $Id:AccountBean.java,v 1.0, 2005-06-24 18:43:38Z, Robert Worsnop$
 *   Currently locked by:$Locker:$
 *   Revision:
 *   $Log:
 *    1    Main      1.0         6/24/2005 2:43:38 PM   Robert Worsnop  
 *   $
 *   Revision 1.2.32.1  2005/04/06 16:25:03  starksm
 *   Fix the license header
 *
 *   Revision 1.2  2001/01/07 23:14:34  peter
 *   Trying to get JAAS to work within test suite.
 *
 *   Revision 1.1.1.1  2000/06/21 15:52:37  oberg
 *   Initial import of jBoss test. This module contains CTS tests, some simple examples, and small bean suites.
 *
 *
 *  
 */
