/*
 *
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.aop.test;

//import java.rmi.*;


import javax.management.ObjectName;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.test.JBossTestCase;

/**
* Sample client for the jboss container.
*
* @author <a href="mailto:bill@burkecentral.com">Bill Burke</a>
* @version $Id:TxUnitTestCase.java,v 1.0, 2005-06-24 19:18:26Z, Robert Worsnop$
*/

public class TxUnitTestCase 
   extends JBossTestCase 
{
   org.apache.log4j.Category log = getLog();
   
   static boolean deployed = false;
   static int test = 0;
   
   public TxUnitTestCase(String name)
   {
      super(name);
   }

   public void testXml() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=TxTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testXml", params, sig);
   }
   
   public void testAnnotated() throws Exception
   {
      RMIAdaptor server = getServer();
      ObjectName testerName = new ObjectName("jboss.aop:name=TxTester");
      Object[] params = {};
      String[] sig = {};
      server.invoke(testerName, "testAnnotated", params, sig);
   }

   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(TxUnitTestCase.class));

      AOPTestSetup setup = new AOPTestSetup(suite, "aoptest.sar");
      return setup; 
   }

}
