/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.logging.Logger;
import org.jboss.system.ServiceMBeanSupport;

import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
/**
 *
 * @see Monitorable
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class TxTester
   extends ServiceMBeanSupport
   implements TxTesterMBean, MBeanRegistration
{
   // Constants ----------------------------------------------------
   // Attributes ---------------------------------------------------
   static Logger log = Logger.getLogger(TxTester.class);
   MBeanServer m_mbeanServer;

   // Static -------------------------------------------------------
   
   // Constructors -------------------------------------------------
   public TxTester()
   {}
   
   // Public -------------------------------------------------------
   
   // MBeanRegistration implementation -----------------------------------
   public ObjectName preRegister(MBeanServer server, ObjectName name)
   throws Exception
   {
      m_mbeanServer = server;
      return name;
   }
   
   public void postRegister(Boolean registrationDone)
   {}
   public void preDeregister() throws Exception
   {}
   public void postDeregister()
   {}

   protected void startService()
      throws Exception
   {
   }

   protected void stopService() {
   }

   public void testXml()
   {
      try{
         log.info("TESTING Tx XML");
         TxPOJO pojo = new TxPOJO();
         log.info("TESTING Never");
         pojo.callNever();
         log.info("TESTING NotSupprted");
         pojo.callNotSupported();
         log.info("TESTING Supports");
         pojo.callSupportsWithTx();
         pojo.callSupportsWithoutTx();

         log.info("TESTING Required");
         pojo.required();

         log.info("TESTING RequiresNew");
         pojo.callRequiresNew();

         log.info("TESTING Mandatory");
         pojo.callMandatoryNoTx();
         pojo.callMandatoryWithTx();
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }

   public void testAnnotated()
   {
      try{
         log.info("TESTING Tx Annotated");
         AnnotatedTxPOJO pojo = new AnnotatedTxPOJO();
         log.info("TESTING Never");
         pojo.callNever();
         log.info("TESTING NotSupprted");
         pojo.callNotSupported();
         log.info("TESTING Supports");
         pojo.callSupportsWithTx();
         pojo.callSupportsWithoutTx();

         log.info("TESTING Required");
         pojo.required();

         log.info("TESTING RequiresNew");
         pojo.callRequiresNew();

         log.info("TESTING Mandatory");
         pojo.callMandatoryNoTx();
         pojo.callMandatoryWithTx();
      }
      catch (Throwable ex)
      {
         log.error("failed", ex);
         throw new RuntimeException(ex.getMessage());
      }
   }

}

