/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.joinpoint.FieldInvocation;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.FieldReadInvocation;
import org.jboss.aop.joinpoint.FieldWriteInvocation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
/**
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class SimpleInterceptor implements org.jboss.aop.advice.Interceptor
{

   public String getName()
   {
      return "SimpleInterceptor";
   }

   public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws Throwable
   {
      System.out.println("interception: " + invocation.getClass().getName());
      if (invocation instanceof MethodInvocation)
      {
         org.jboss.aop.joinpoint.MethodInvocation methodInvocation = (org.jboss.aop.joinpoint.MethodInvocation)invocation;
         Method m = methodInvocation.getMethod();
         if (m.getName().equals("whazup")) return "nada";
         lastIntercepted = m.getName();
         String transattr = (String)invocation.getMetaData("transaction", "trans-attribute"); 
         System.out.println("trans-attribute: " + transattr);
         lastTransAttributeAccessed = transattr;
      }
      else if (invocation instanceof FieldReadInvocation || invocation instanceof FieldWriteInvocation)
      {
         org.jboss.aop.joinpoint.FieldInvocation fieldInvocation = (org.jboss.aop.joinpoint.FieldInvocation)invocation;
         Field field = fieldInvocation.getField();
         System.out.println("**** simple: " + field.getName());
         lastFieldIntercepted = field.getName();
         Object obj =invocation.getMetaData("transaction", "trans-attribute");
         System.out.println(field.getName() + "type**" + obj.getClass().getName());
         String transattr = (String)invocation.getMetaData("transaction", "trans-attribute");
         System.out.println("trans-attribute: " + transattr);
         lastFieldTransAttributeAccessed = transattr;
      }
      return invocation.invokeNext();
   }

   public static String lastIntercepted;
   public static String lastTransAttributeAccessed;
   public static String lastFieldIntercepted;
   public static String lastFieldTransAttributeAccessed;
}

