/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;
import java.util.ArrayList;
/**
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class Person
{
   public Person() {}

   public Person(String name,
                 int age,
                 Address address)
   {
      this.name = name;
      this.age = age;
      this.address = address;
      this.hobbies = new ArrayList();
   }

   private String name;
   private int age;
   private Address address;
   private ArrayList hobbies;

   public void testOptimisticLock()
   {
      name = "Billy";
      requiresNew();
   }

   public void requiresNew()
   {
      name = "William";
   }

   public void testRollback()
   {
      name = "Billy";
      throw new RuntimeException("Roll it back");
   }

   public void setNameTransactional(String newName)
   {
      name = newName;
   }

   public void setName(String newName)
   {
      name = newName;
   }

   public String getName() 
   {
      return name;
   }

   public int getAge() { return age; }
   public void setAge(int newAge) { age = newAge; }

   public void testDifferentFields()
   {
      age = 5;
      requiresNew();
   }

   public void testOptimisticLockWithAddress()
   {
      address.setCity("Billerica");
      requiresNewForAddress();
   }

   public void requiresNewForAddress()
   {
      address.setCity("Rutland");
   }

   
   public void testRollbackForAddress()
   {
      address.setCity("Billerica");
      throw new RuntimeException("Roll it back");
   }

   public void testDifferentFieldsForAddress()
   {
      address.setState("VT");
      requiresNewForAddress();
   }

   public Address getAddress() { return address; }
   public ArrayList getHobbies() { return hobbies; }

   public void testListOptimisticLock()
   {
      hobbies.add("baseball");
      try
      {
         requiresNewForList();
      }
      catch (RuntimeException ex)
      {
         ex.printStackTrace();
         throw ex;
      }
   }

   public void requiresNewForList()
   {
      hobbies.add("football");
   }


   public void testListRollback()
   {
      hobbies.add("tennis");
      throw new RuntimeException("Roll it back");
   }

   public void addHobby(String hobbie)
   {
      hobbies.add(hobbie);
   }
   
}

