/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.joinpoint.ConstructorInvocation;

import java.lang.reflect.Method;
/**
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class POJOMethodInterceptor implements Interceptor
{

   public String getName()
   {
      return "POJOMethodInterceptor";
   }

   public Object invoke(Invocation invocation) throws Throwable
   {
      Object rtn = invocation.invokeNext();
      wasHit = true;
      MethodInvocation m = (MethodInvocation)invocation;
      POJOConstructorTest pojo = (POJOConstructorTest)m.getTargetObject();
      String data = (String)invocation.getMetaData("test", "data");
      pojo.data = data;
      return rtn;
   }

   public static boolean wasHit = false;

}

