/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.tm.TxUtils;

import javax.naming.InitialContext;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

/**
 * @@org.jboss.aspects.tx.Tx (org.jboss.aspects.tx.TxType.NOTSUPPORTED)
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class AnnotatedTxPOJO
{
   TransactionManager tm;

   public AnnotatedTxPOJO() throws Exception
   {
      tm = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
   }

   /**
    * @@org.jboss.aspects.tx.Tx (org.jboss.aspects.tx.TxType.NEVER)
    */
   public void never() {}

   public void callNever() throws Exception
   {
      boolean exceptionThrown = false;
      tm.begin();
      try
      {
         never();
      }
      catch (Exception ex)
      {
         exceptionThrown = true;
      }
      tm.commit();
      if (!exceptionThrown) throw new Exception("failed on mandatory no tx call");
   }

   /**
    * @@org.jboss.aspects.tx.Tx (org.jboss.aspects.tx.TxType.NOTSUPPORTED)
    */
   public void notsupported() throws Exception
   {
      if (tm.getTransaction() != null) throw new Exception("notsupported() method has tx set");
   }

   public void callNotSupported() throws Exception
   {
      tm.begin();
      notsupported();
      tm.commit();
   }

   /**
    * @@org.jboss.aspects.tx.Tx (org.jboss.aspects.tx.TxType.SUPPORTS)
    */
   public void supports(Transaction tx) throws Exception
   {
      Transaction tmTx = tm.getTransaction();
      if (tx != tmTx) throw new Exception("supports didn't work");
   }

   public boolean hasActiveTransaction() throws Exception
   {
      Transaction tx = tm.getTransaction();
      if (tx == null)
      {
         System.out.println("Transaction: is null");
      } // end of if ()
      else
      {
         System.out.println("Transaction: status " + tx.getStatus() + " of tx" + tx);
      } // end of else

      return TxUtils.isActive(tx);
   }

   public void callSupportsWithTx() throws Exception
   {
      tm.begin();
      Transaction tx = tm.getTransaction();
      supports(tx);
      tm.commit();
   }

   public void callSupportsWithoutTx() throws Exception
   {
      supports(null);
   }

   /**
    * @@org.jboss.aspects.tx.Tx (org.jboss.aspects.tx.TxType.REQUIRED)
    */
   public void required() throws Exception
   {
      if (tm.getTransaction() == null) throw new Exception("rquired() method has no tx set");
   }


   /**
    * @@org.jboss.aspects.tx.Tx (org.jboss.aspects.tx.TxType.REQUIRESNEW)
    */
   public void requiresNew(Transaction tx) throws Exception
   {
      Transaction tmTx = tm.getTransaction();
      if (tx == tmTx
          || (tx != null && tx.equals(tmTx))) throw new Exception("transactions shouldn't be equal");
      if (tmTx == null) throw new Exception("tx is null in RequiresNew");
   }
   public void callRequiresNew() throws Exception
   {
      tm.begin();
      Transaction tx = tm.getTransaction();
      requiresNew(tx);
      tm.commit();
   }

   /**
    * @@org.jboss.aspects.tx.Tx (org.jboss.aspects.tx.TxType.MANDATORY)
    */
   public void mandatory() {}

   public void callMandatoryNoTx() throws Exception
   {
      boolean exceptionThrown = false;
      try
      {
         mandatory();
      }
      catch (Exception ex)
      {
         exceptionThrown = true;
      }
      if (!exceptionThrown) throw new Exception("failed on mandatory no tx call");
   }

   public void callMandatoryWithTx() throws Exception
   {
      tm.begin();
      mandatory();
      tm.commit();
   }


}

