/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.aop.bean;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;

import java.lang.reflect.Method;
/**
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision:1$
 */
public class AfterInterceptor implements org.jboss.aop.advice.Interceptor
{

   public String getName()
   {
      return "AfterInterceptor";
   }

   public Object invoke(org.jboss.aop.joinpoint.Invocation invocation) throws Throwable
   {
      System.out.println("AfterInterceptor interception: " + invocation.getClass().getName());
      org.jboss.aop.joinpoint.MethodInvocation methodInvocation = (org.jboss.aop.joinpoint.MethodInvocation)invocation;
      Method m = methodInvocation.getMethod();
      lastIntercepted = m.getName();
      String transattr = (String)invocation.getMetaData("transaction", "trans-attribute");
      System.out.println("trans-attribute: " + transattr);
      lastTransAttributeAccessed = transattr;
      return invocation.invokeNext();
   }

   public static String lastIntercepted;
   public static String lastTransAttributeAccessed;
}

