/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.ant.taskdefs;


import org.apache.tools.ant.taskdefs.optional.junit.JUnitTest;
import org.apache.tools.ant.taskdefs.optional.junit.XMLJUnitResultFormatter;

/**
 * This class only serves the proposite of keep multiple JUnit runnings between different configurations.
 * For example, if you run a testcase as cluster, and the same testcase as singlenode, we want to keep both results in the JUnitReport.
 * This is a simple implementation that uses a variable defined jboss-configuration and put that as part of the name.
 * @author Clebert Suconic
 */
public class XMLJUnitMultipleResultFormatter extends XMLJUnitResultFormatter 
{
	
    public void startTestSuite(JUnitTest test) 
    { 
        String configuration = (String)System.getProperties().get("jboss-junit-configuration");
    	
    	if (configuration!=null && !configuration.trim().equals("")) 
        {
                test.setName(test.getName() + "(" + configuration + ")");
        }

        super.startTestSuite(test);    	
    }

}
