/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.system;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.ObjectName;

/**
 * ServiceContext holds information for the Service
 *
 * @see Service
 * @see ServiceMBeanSupport
 * 
 * @author <a href="mailto:marc.fleury@jboss.org">marc fleury</a>
 * @author <a href="mailto:dimitris@jboss.org">Dimitris Andreadis</a>
 * @version $Revision:1$
 */
public class ServiceContext implements Serializable
{
   /** @since 4.0.2 */
   private static final long serialVersionUID = 7461263042948325633L;

   /** The possible string-fied states */
   private static final String[] stateNames = {
         "INSTALLED",
         "CONFIGURED",
         "CREATED",
         "RUNNING",
         "FAILED",
         "STOPPED",
         "DESTROYED",
         "NOTYETINSTALLED"
      };
   
   /** Valid service states */
   public static final int INSTALLED = 0;
   public static final int CONFIGURED = 1;
   public static final int CREATED = 2;
   public static final int RUNNING = 3;
   public static final int FAILED = 4;
   public static final int STOPPED = 5;
   public static final int DESTROYED = 6;
   public static final int NOTYETINSTALLED = 7;
   
   /** The name of the service **/
   public ObjectName objectName;
   
   /** State of the service **/
   public int state = NOTYETINSTALLED;
   
   /** Dependent beans **/
   public List iDependOn = new LinkedList();
   
   /** Beans that depend on me **/
   public List dependsOnMe = new LinkedList();
   
   /** The fancy proxy to my service calls **/
   public Service proxy;

   /** Cause for failure */
   public Throwable problem;

   // Object overrides ----------------------------------------------
   
   public String toString()
   {
      StringBuffer sbuf = new StringBuffer(512);
      
      sbuf.append("ObjectName: ").append(objectName);
      sbuf.append("\n  State: ").append(stateNames[state]);

      if (state == FAILED && problem != null) 
      {
         sbuf.append("\n  Reason: ").append(problem.toString());
      }
      printList(sbuf, "\n  I Depend On:", iDependOn);
      printList(sbuf, "\n  Depends On Me:", dependsOnMe);

      // this magically makes *all* jmx-console outputs look better :)
      sbuf.append("\n");
      
      return sbuf.toString();
   }
   
   // Private -------------------------------------------------------
   
   private void printList(StringBuffer sbuf, String msg, List ctxs)
   {
      if (ctxs.size() > 0)
      {
         // only out stuff, if there are indeed dependencies
         sbuf.append(msg);
         for (Iterator i = ctxs.iterator(); i.hasNext(); )
         {
            ServiceContext sc = (ServiceContext) i.next();
            sbuf.append("\n    ");
            sbuf.append(sc.objectName);
         }
      }
   }
}
