/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.jmx.adaptor.rmi;

import javax.management.Notification;
import javax.management.NotificationListener;
import org.jboss.logging.Logger;

/**
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class NotificationListenerDelegate
   implements NotificationListener
{
   private static Logger log = Logger.getLogger(NotificationListenerDelegate.class);
   /** */
   private RMINotificationListener client;

   public NotificationListenerDelegate(RMINotificationListener client)
   {
      this.client = client;
   }

   public void handleNotification(Notification notification,
      Object handback)
   {
      try
      {
         log.info("Sending notification to client, event:"+notification);
         client.handleNotification(notification, handback);
      }
      catch(Throwable t)
      {
         log.warn("Failed to notify client", t);
      }
   }
}
