/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.jms.jndi;

import java.util.Properties;

import javax.naming.Context;
import javax.naming.NamingException;
/**
 * An abstract implementaion of {@link JMSProviderAdapter}.  Sub-classes must
 * provide connection names via instance initialzation and provide an 
 * implementaion of {@link #getInitialContext}.
 *
 * 6/22/01 - hchirino - The queue/topic jndi references are now configed via JMX
 *
 * @version <pre>$Revision:1$</pre>
 * @author  <a href="mailto:jason@planet57.com">Jason Dillon</a>
 * @author  <a href="mailto:cojonudo14@hotmail.com">Hiram Chirino</a>
 */
public abstract class AbstractJMSProviderAdapter implements JMSProviderAdapter, java.io.Serializable
{
   static final long serialVersionUID = 3573606612665654983L;

   /** The name of the provider. */
   protected String name;

   /** The properties. */
   protected Properties properties;

   /** The factory name to use. */
   protected String factoryRef;

   /** The queue factory name to use. */
   protected String queueFactoryRef;

   /** The topic factory name to use. */
   protected String topicFactoryRef;

   /**
    * Set the name of the provider.
    *
    * @param name    The provider name.
    */
   public void setName(final String name)
   {
      this.name = name;
   }

   /**
    * Get the name of the provider.
    *
    * @return  The provider name.
    */
   public final String getName()
   {
      return name;
   }

   public void setProperties(final Properties properties)
   {
      this.properties = properties;
   }

   public final Properties getProperties()
   {
      return properties;
   }

   /**
    * ???
    * 
    * @return  ???
    */
   public String getFactoryRef()
   {
      return factoryRef;
   }

   /**
    * ???
    * 
    * @return  ???
    */
   public String getQueueFactoryRef()
   {
      return queueFactoryRef;
   }

   /**
    * ???
    * 
    * @return  ???
    */
   public String getTopicFactoryRef()
   {
      return topicFactoryRef;
   }

   /**
    * ???
    * 
    * @return  ???
    */
   public void setFactoryRef(String newFactoryRef)
   {
      factoryRef = newFactoryRef;
   }

   /**
    * ???
    * 
    * @return  ???
    */
   public void setQueueFactoryRef(String newQueueFactoryRef)
   {
      queueFactoryRef = newQueueFactoryRef;
   }

   /**
    * ???
    * 
    * @return  ???
    */
   public void setTopicFactoryRef(String newTopicFactoryRef)
   {
      topicFactoryRef = newTopicFactoryRef;
   }
}