/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 * 
 */
package org.jboss.security.jacc;

import java.net.URL;
import java.security.Policy;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentReaderHashMap;
import org.jboss.util.state.StateMachine;
import org.jboss.util.state.xml.StateMachineParser;

/** org.jboss.security.provider
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class JBossPolicyConfigurationFactory
   extends PolicyConfigurationFactory
{
   private StateMachine configStateMachine;
   private ConcurrentReaderHashMap policyConfigMap = new ConcurrentReaderHashMap();
   private DelegatingPolicy policy;

   /** Build the JACC policy configuration state machine from the
    * jacc-policy-config-states.xml file.
    * 
    */ 
   public JBossPolicyConfigurationFactory()
   {
      try
      {
         // Setup the state machine config
         ClassLoader loader = Thread.currentThread().getContextClassLoader();
         URL states = loader.getResource("org/jboss/security/jacc/jacc-policy-config-states.xml");
         StateMachineParser smp = new StateMachineParser();
         configStateMachine = smp.parse(states);        
      }
      catch(Exception e)
      {
         IllegalStateException ex = new IllegalStateException("Failed to parse jacc-policy-config-states.xml");
         ex.initCause(e);
         throw ex;
      }
      // Get the DelegatingPolicy
      Policy p = Policy.getPolicy();
      if( (p instanceof DelegatingPolicy) == false )
      {
         // Assume that the installed policy delegates to the DelegatingPolicy
         p = DelegatingPolicy.getInstance();
      }
      policy = (DelegatingPolicy) p;
   }

   public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove)
      throws PolicyContextException
   {
      JBossPolicyConfiguration pc = (JBossPolicyConfiguration) policyConfigMap.get(contextID);
      if( pc == null )
      {
         StateMachine sm = (StateMachine) configStateMachine.clone();
         pc = new JBossPolicyConfiguration(contextID, policy, sm);
         policyConfigMap.put(contextID, pc);
      }
      pc.initPolicyConfiguration(remove);
      return pc;
   }

   public boolean inService(String contextID)
      throws PolicyContextException
   {
      boolean inService = false;
      JBossPolicyConfiguration pc = (JBossPolicyConfiguration) policyConfigMap.get(contextID);
      if( pc != null )
         inService = pc.inService();
      return inService;
   }
}
