/*
 * JBoss, Home of Professional Open Source
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.security.auth.certs;

import java.security.cert.X509Certificate;
import java.security.KeyStore;

/**
 * A X509CertificateVerifier that accepts any cert.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public class AnyCertVerifier implements X509CertificateVerifier
{
   /**
    * Returns true regardless of the arguments.
    * 
    * @param cert - the X509Certificate to verifier
    * @param alias - the expected keystore alias
    * @param keyStore - the keystore for the cert
    * @param trustStore - the truststore for the cert signer
    * @return true always.
    */ 
   public boolean verify(X509Certificate cert, String alias,
      KeyStore keyStore, KeyStore trustStore)
   {
      return true;
   }
}
