/*
* JBoss, the OpenSource J2EE webOS
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.security;

import java.security.Principal;
import java.security.cert.X509Certificate;

/** An interface for converting an X509 cert to a Principal
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision:1$
 */
public interface CertificatePrincipal
{
   /**
    * Return the Principal associated with the specified chain of X509
    * client certificates.  If there is none, return <code>null</code>.
    *
    * @param certs Array of client certificates, with the first one in
    * the array being the certificate of the client itself.
    */
   public Principal toPrinicipal(X509Certificate[] certs);
}
