/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.mock;

import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvoker;

import java.util.Map;

/**
 * MockServerInvoker
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @version $Revision:1$
 */
public class MockServerInvoker extends ServerInvoker
{
   boolean loaded = false;

   public MockServerInvoker(InvokerLocator locator)
   {
      super(locator);
   }

   public MockServerInvoker(InvokerLocator locator, Map configuration)
   {
      super(locator, configuration);
   }

   protected String getDefaultDataType()
   {
      return null;
   }

   public String getMBeanObjectName()
   {
      return "jboss.remoting:service=invoker,transport=mock";
   }

   /**
    * returns true if the transport is bi-directional in nature, for example,
    * SOAP in unidirectional and SOCKETs are bi-directional (unless behind a firewall
    * for example).
    *
    * @return
    */
   public boolean isTransportBiDirectional()
   {
      return false;
   }

}
