/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.performance;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class PerformanceReporter
{
   /**
    * Will write to report file with all the values passed.
    *
    * @param testName   Name of test run. Typically should be class and test method name.
    * @param totalCount Total number of iterations for a test (i.e. number of calls to the server).
    * @param totalTime  How long, in milliseconds, that the test took.  This is really how long it took
    *                   to make the calls to the server and not the extra time for test setup.
    * @param metadata   Any key value pairs would like added to the report.  For example, would want to
    *                   add the transport and maybe the total number of server count.
    * @throws IOException
    */
   public static void writeReport(String testName, long totalTime, int totalCount, Map metadata) throws IOException
   {
      File reportFile = new File("performance_report.txt");
      if(!reportFile.exists())
      {
         reportFile.createNewFile();
      }

      FileWriter reportWriter = new FileWriter(reportFile, true);
      reportWriter.write("\n\nTest results for test: " + testName + "\n");
      reportWriter.write("When run: " + new Date());
      reportWriter.write("\nTotal count: " + totalCount);
      reportWriter.write("\nTotal time: " + totalTime);
      if(metadata != null)
      {
         Iterator itr = metadata.keySet().iterator();
         while(itr.hasNext())
         {
            Object key = itr.next();
            Object value = metadata.get(key);
            reportWriter.write("\n" + key + " = " + value);
         }
      }
      reportWriter.write("\n\n");
      reportWriter.close();
   }
}