/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.performance;

import org.apache.log4j.Level;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ShutdownListener;
import org.jboss.remoting.transport.socket.InvokerServerTest;

/**
 * @author <a href="mailto:telrod@vocalocity.net">Tom Elrod</a>
 * @version $Revision:1$
 */
public class PerformanceInvokerServer extends InvokerServerTest implements ShutdownListener
{
   public boolean timeToShutdown = false;

   private final Object waitObj = new Object();


   public PerformanceInvokerServer(int instances)
   {
      super(instances);
   }

   public PerformanceInvokerServer(String name)
   {
      super(name);
   }

   /**
    * Should be called when ready to shutdown.  Will notify all other remote test
    * instances and will then block until all other instances have made the same call.
    *
    * @throws Exception
    */
   public void shutdown() throws Exception
   {
      synchronized(waitObj)
      {
         try
         {
            waitObj.wait(10 * 1000); // timeout if not notified
         }
         catch(InterruptedException e)
         {
            System.out.println("Got interrupted exception.");
         }
      }
      super.shutdown();
   }

   public PerformanceInvokerServer(String transport, int port)
   {
      super(transport, port);
   }

   public PerformanceInvokerServer(String transport, int port, int instances)
   {
      super(transport, port, instances);
   }

   protected ServerInvocationHandler getServerInvocationHandler()
   {
      return new TestServerInvocationHandler(this);
   }

   protected String getSubsystem()
   {
      return "test";
   }

   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jgroups").setLevel(Level.INFO);
      //org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("org.jboss.remoting.performance").setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("test").setLevel(Level.DEBUG);

      PerformanceInvokerServer server = null;
      if(args.length == 1)
      {
         int instances = Integer.parseInt(args[0]);
         server = new PerformanceInvokerServer(instances);
      }
      else if(args.length == 2)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         server = new PerformanceInvokerServer(transport, port);
      }
      else if(args.length == 3)
      {
         String transport = args[0];
         int port = Integer.parseInt(args[1]);
         int instances = Integer.parseInt(args[2]);
         server = new PerformanceInvokerServer(transport, port, instances);
      }
      else
      {
         server = new PerformanceInvokerServer(InvokerServerTest.class.getName());
         System.out.println("Using default transport (" + server.getTransport() +
                            ") and default port (" + server.getPort() + ") and " +
                            "default number of instances (" + server.getNumberOfInstances() + ")" +
                            "\nCan enter transport, port, and instances via command line.");
      }

      try
      {
         server.serverTest();
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

   public void shutdownTest()
         throws Exception
   {
      synchronized(waitObj)
      {
         waitObj.notify();
      }
   }


}
