/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshall.http.metadata;

import org.jboss.remoting.marshal.http.HTTPUnMarshaller;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class HTTPUnMarshallerMock extends HTTPUnMarshaller
{
   private Map metadata = new HashMap();

   /**
    * Will try to unmarshall data from inputstream.  Will try to convert to either an object
    * or a string.  If there is no data to read, will return null.
    *
    * @param inputStream
    * @return
    * @throws java.io.IOException
    * @throws ClassNotFoundException
    */
   public Object read(InputStream inputStream, Map metadata) throws IOException, ClassNotFoundException
   {
      Object ret = super.read(inputStream, metadata);
      this.metadata.putAll(metadata);
      return ret;
   }

   public Map getMetadata()
   {
      return metadata;
   }
}