/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshall.dynamic.remote.socket;

import org.apache.log4j.Level;
import org.jboss.dtf.MultipleTestRunner;
import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

/**
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class MarshallerLoadingClient extends AbstractInvokerTest implements MarshallerLoadingConstants
{
   public MarshallerLoadingClient(String name)
   {
      super(name);
   }

   public MarshallerLoadingClient(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public MarshallerLoadingClient(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public MarshallerLoadingClient(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }

   public void testInvocation() throws Throwable
   {
      InvokerLocator locator = new InvokerLocator(locatorURI);
      System.out.println("Calling remoting server with locator uri of: " + locatorURI);

      Client remotingClient = new Client(locator, null);
      Object response = remotingClient.invoke("Do something", null);
      assertTrue(true);

      System.out.println("Invocation response: " + response);
   }

   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);
      org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.DEBUG);

      /*
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }
      */
      MarshallerLoadingClient client = new MarshallerLoadingClient(MarshallerLoadingClient.class.getName());
      try
      {
         MultipleTestRunner runner = new MultipleTestRunner();
         runner.doRun(client, true);
      }
      catch(Throwable e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }


}