/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshall.dynamic.local;

import org.jboss.remoting.marshal.serializable.SerializableMarshaller;

import java.io.IOException;
import java.io.OutputStream;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class TestMarshaller extends SerializableMarshaller
{
   public final static String DATATYPE = "test";

   //private TestWrapper wrapper = null;

   /**
    * Take the data object and write to the output.  Has ben customized
    * for working with ObjectOutputStreams since requires extra messaging.
    *
    * @param dataObject Object to be writen to output
    * @param output     The data output to write the object
    *                   data to.
    */
   public void write(Object dataObject, OutputStream output) throws IOException
   {
      TestWrapper wrapper = new TestWrapper(dataObject);
      super.write(wrapper, output);
   }

   public String getDataType()
   {
      return DATATYPE;
   }
}