/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.marshall.dynamic.local;

import org.apache.log4j.Level;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.transport.Connector;

import javax.management.MBeanServer;
import java.io.IOException;
import java.util.Enumeration;

/**
 * Simple remoting server.  Uses inner class SampleInvocationHandler
 * as the invocation target handler class.
 *
 * @author <a href="mailto:telrod@e2technologies.net">Tom Elrod</a>
 */
public class MarshallerLoadingServer extends AbstractInvokerTest  implements MarshallerLoadingConstants
{
   private static final Logger log = Logger.getLogger(MarshallerLoadingServer.class);

   // String to be returned from invocation handler upon client invocation calls.
   private static final String RESPONSE_VALUE = "This is the return to SampleInvocationHandler invocation";

   public MarshallerLoadingServer(String name)
   {
      super(name);
   }

   public MarshallerLoadingServer(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public MarshallerLoadingServer(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public MarshallerLoadingServer(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }


   public void setupServer() throws Exception
   {
      try
      {
         log.info("2");
         InvokerLocator locator = new InvokerLocator(locatorURI);
         System.out.println("Starting remoting server with locator uri of: " + locatorURI);
         log.info("Starting remoting server with locator uri of: " + locatorURI);
         Connector connector = new Connector();
         log.info("3");
         connector.setInvokerLocator(locator.getLocatorURI());
         connector.start();

         SampleInvocationHandler invocationHandler = new SampleInvocationHandler();
         // first parameter is sub-system name.  can be any String value.
         connector.addInvocationHandler("sample", invocationHandler);
      }
      catch(Exception e)
      {
         e.printStackTrace();
         log.error("Error starting server.", e);
         throw e;
      }
   }

   public void serverTest() throws Exception
   {
      log.info("1");
         setupServer();
         startup(getNumberOfInstances());

         Thread.sleep(5000);

         shutdown();
   }

   public void setLogging()
   {
      org.apache.log4j.BasicConfigurator.configure();
      org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("org.jboss.remoting").setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("org.jboss.remoting.marshall.dynamic.local").setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("org.jboss.dtf").setLevel(Level.DEBUG);
      org.apache.log4j.Category.getInstance("org.jgroups").setLevel(Level.FATAL);

      org.apache.log4j.SimpleLayout layout = new org.apache.log4j.SimpleLayout();
      try
      {
         org.apache.log4j.FileAppender fileAppender = new org.apache.log4j.FileAppender(layout, getClass().getName() + "_output.log");
         fileAppender.setThreshold(Level.DEBUG);
         org.apache.log4j.Category.getRoot().addAppender(fileAppender);
      }
      catch(IOException e)
      {
         e.printStackTrace();
      }

//      org.apache.log4j.ConsoleAppender consoleAppender = new org.apache.log4j.ConsoleAppender();
//      consoleAppender.setThreshold(Level.INFO);
//      org.apache.log4j.Category.getRoot().addAppender(consoleAppender);

      //System.out.println("Root log level = " + org.apache.log4j.Category.getRoot().getLevel());
      Enumeration appenders = org.apache.log4j.Category.getRoot().getAllAppenders();
      while(appenders.hasMoreElements())
      {
         org.apache.log4j.Appender appender = (org.apache.log4j.Appender) appenders.nextElement();
         //System.out.println(appender.getName());
         if(appender instanceof org.apache.log4j.ConsoleAppender)
         {
            ((org.apache.log4j.ConsoleAppender) appender).setThreshold(Level.INFO);
         }
      }
   }

   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      /*
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }
      */
      MarshallerLoadingServer server = new MarshallerLoadingServer(MarshallerLoadingServer.class.getName());

      //DEBUG -TME
      server.setLogging();

      try
      {
         server.serverTest();
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }

   /**
    * Simple invocation handler implementation.
    */
   public static class SampleInvocationHandler implements ServerInvocationHandler
   {
      /**
       * called to handle a specific invocation
       *
       * @param invocation
       * @return
       * @throws Throwable
       */
      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         // Print out the invocation request
         System.out.println("Invocation request is: " + invocation.getParameter());

         // Just going to return static string as this is just simple example code.
         return RESPONSE_VALUE;
      }

      /**
       * Adds a callback handler that will listen for callbacks from
       * the server invoker handler.
       *
       * @param callbackHandler
       */
      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * Removes the callback handler that was listening for callbacks
       * from the server invoker handler.
       *
       * @param callbackHandler
       */
      public void removeListener(InvokerCallbackHandler callbackHandler)
      {
         // NO OP as do not handling callback listeners in this example
      }

      /**
       * set the mbean server that the handler can reference
       *
       * @param server
       */
      public void setMBeanServer(MBeanServer server)
      {
         // NO OP as do not need reference to MBeanServer for this handler
      }

      /**
       * set the invoker that owns this handler
       *
       * @param invoker
       */
      public void setInvoker(ServerInvoker invoker)
      {
         // NO OP as do not need reference back to the server invoker
      }

   }
}