/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.interceptor;

import org.jboss.logging.Logger;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerCallbackHandler;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;

import javax.management.MBeanServer;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class TestInvocationHandler implements ServerInvocationHandler
{
   private ServerInvoker invoker;

   private static final Logger log = Logger.getLogger(TestInvocationHandler.class);


   /**
    * set the invoker that owns this handler
    *
    * @param invoker
    */
   public void setInvoker(ServerInvoker invoker)
   {
      this.invoker = invoker;
   }

   /**
    * set the mbean server that the handler can reference
    *
    * @param server
    */
   public void setMBeanServer(MBeanServer server)
   {
   }

   public Object invoke(InvocationRequest invocation)
         throws Throwable
   {
      Object ret = null;
      Object param = invocation.getParameter();
      if(param instanceof TestInvocation)
      {
         Object obj = ((TestInvocation) param).getArgument();
         if(obj instanceof TestTarget)
         {
            TestTarget testParamVal = (TestTarget) obj;
            ret = new Boolean(new TestTarget().equals(testParamVal));
         }
      }
      else
      {
         log.info("Don't recognize the parameter type, so just returning it.");
         ret = param;
      }
      return ret;
   }

   /**
    * Adds a callback handler that will listen for callbacks from
    * the server invoker handler.
    *
    * @param callbackHandler
    */
   public void addListener(InvokerCallbackHandler callbackHandler)
   {
   }

   /**
    * Removes the callback handler that was listening for callbacks
    * from the server invoker handler.
    *
    * @param callbackHandler
    */
   public void removeListener(InvokerCallbackHandler callbackHandler)
   {
   }
}
