/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.interceptor;

import org.apache.log4j.Level;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ident.Identity;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
import org.jboss.remoting.network.NetworkRegistry;
import org.jboss.remoting.transport.Connector;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

/**
 * @author <a href="mailto:tom@jboss.org">Tom Elrod</a>
 */
public class ServerInterceptorTest
{
   private InvokerLocator locator;

   public void setLocator(InvokerLocator locator)
   {
      this.locator = locator;
   }

   protected void setup()
   {
      try
      {
         System.setProperty("jboss.identity", Identity.createUniqueID());
         MBeanServer server = MBeanServerFactory.createMBeanServer();

         System.out.println("my identity is: " + Identity.get(server));


         NetworkRegistry registry = NetworkRegistry.getInstance();
         server.registerMBean(registry, new ObjectName("remoting:type=NetworkRegistry"));

         //int port = PortUtil.findFreePort();

         Connector connector = new Connector();
         connector.setInvokerLocator(locator.getLocatorURI());
         ObjectName obj = new ObjectName("jboss.remoting:type=Connector,transport=" + locator.getProtocol());
         server.registerMBean(connector, obj);

         connector.start();

         connector.addInvocationHandler("test", new TestInvocationHandler());

//          MulticastDetector detector = new MulticastDetector();
//          server.registerMBean(detector, new ObjectName("remoting:type=Detector,transport=multicast"));
//          detector.start();

         // TODO: -TME Not needed unless want to make jmx invocation within handler
//         TestTarget target = new TestTarget();
//         ObjectName objName = new ObjectName("test:type=UnifiedInvoker");
//         server.registerMBean(target, objName);
//         Registry.bind("test:type=UnifiedInvoker", objName);

      }
      catch(Throwable e)
      {
         e.printStackTrace();
      }

   }

   public static void main(String[] args)
   {
      try
      {
         //org.apache.log4j.BasicConfigurator.configure();
         org.apache.log4j.Category.getRoot().setLevel(Level.DEBUG);

         int port = 8081;
         String transport = "socket";
//         InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port + "/?" +
//               InvokerLocator.DATATYPE + "=" + SerializableUnMarshaller.DATATYPE);
         InvokerLocator locator = new InvokerLocator(transport + "://localhost:" + port + "/?" +
                                                     InvokerLocator.DATATYPE + "=" + SerializableUnMarshaller.DATATYPE);

         ServerInterceptorTest server = new ServerInterceptorTest();
         server.setLocator(locator);
         server.setup();

         while(true)
         {
            Thread.sleep(1000);
         }
      }
      catch(Exception e)
      {
         e.printStackTrace();
      }
   }

   /**
    * When an object implementing interface <code>Runnable</code> is used
    * to create a thread, starting the thread causes the object's
    * <code>run</code> method to be called in that separately executing
    * thread.
    * <p/>
    * The general contract of the method <code>run</code> is that it may
    * take any action whatsoever.
    *
    * @see Thread#run()
    */
   public void run()
   {
      setup();
   }
}