/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.handler.mbean;

import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.transport.Connector;

import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class ServerTest extends AbstractInvokerTest
{
   // Default locator values
   private static String transport = "socket";
   private static String host = "localhost";
   private static int port = 5400;

   private String locatorURI = null;

   // String to be returned from invocation handler upon client invocation calls.
   public static final String RESPONSE_VALUE = "This is the return from the TestServer invocation";

   public ServerTest(String name)
   {
      super(name);
   }

   public ServerTest(String name, String locatorURI)
   {
      super(name);
      this.locatorURI = locatorURI;
   }

   public ServerTest(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public ServerTest(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public ServerTest(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }


   public void setupServer() throws Exception
   {
      MBeanServer server = MBeanServerFactory.createMBeanServer();

      InvokerLocator locator = new InvokerLocator(locatorURI);
      System.out.println("Starting remoting server with locator uri of: " + locatorURI);
      Connector connector = new Connector();
      connector.setInvokerLocator(locator.getLocatorURI());
      connector.start();

      server.registerMBean(connector, new ObjectName("test:type=connector,transport=socket"));

      // now create Mbean handler and register with mbean server
      MBeanHandler handler = new MBeanHandler();
      ObjectName objName = new ObjectName("test:type=handler");
      server.registerMBean(handler, objName);

      connector.addInvocationHandler("test", objName);
   }

   public void serverTest() throws Exception
   {
      try
      {
         setupServer();
         startup(getNumberOfInstances());
         shutdown();
      }
      catch(Exception e)
      {
         throw e;
      }
   }


   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }
      String locatorURI = transport + "://" + host + ":" + port;
      ServerTest serverTest = new ServerTest(ServerTest.class.getName(), locatorURI);
      try
      {
         serverTest.serverTest();

         // sleep the thread for 10 seconds while waiting for client to call
         Thread.sleep(10000);
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }
}