/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.remoting.handler.mbean;

import org.jboss.dtf.MultipleTestRunner;
import org.jboss.remoting.AbstractInvokerTest;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class ClientTest  extends AbstractInvokerTest
{
   // Default locator values
   private static String transport = "socket";
   private static String host = "localhost";
   private static int port = 5400;

   private String locatorURI = null;

   public ClientTest(String name)
   {
      super(name);
   }

   public ClientTest(String name, String locatorURI)
   {
      super(name);
      this.locatorURI = locatorURI;
   }
   public ClientTest(String name, int numberOfInstances)
   {
      super(name, numberOfInstances);
   }

   public ClientTest(String name, String transport, int port)
   {
      super(name, transport, port);
   }

   public ClientTest(String name, String transport, int port, int numberOfInstances)
   {
      super(name, transport, port, numberOfInstances);
   }

   public void testMakeInvocation() throws Throwable
   {
      if(locatorURI == null)
      {
         locatorURI = transport + "://" + host + ":" + port;
      }
      InvokerLocator locator = new InvokerLocator(locatorURI);
      System.out.println("Calling remoting server with locator uri of: " + locatorURI);

      Client remotingClient = new Client(locator);
      Object response = remotingClient.invoke("Do something");

      assertEquals(response,ServerTest.RESPONSE_VALUE);
   }

   /**
    * Can pass transport and port to be used as parameters.
    * Valid transports are 'rmi' and 'socket'.
    *
    * @param args
    */
   public static void main(String[] args)
   {
      if(args != null && args.length == 2)
      {
         transport = args[0];
         port = Integer.parseInt(args[1]);
      }
      String locatorURI = transport + "://" + host + ":" + port;
      ClientTest clientTest = new ClientTest(ClientTest.class.getName(), locatorURI);
      try
      {
         MultipleTestRunner runner = new MultipleTestRunner();
         runner.doRun(clientTest, true);
      }
      catch(Throwable e)
      {
         e.printStackTrace();
         System.exit(1);
      }
      System.exit(0);
   }
}