/***************************************
 *                                     *
 *  JBoss: The OpenSource J2EE WebOS   *
 *                                     *
 *  Distributable under LGPL license.  *
 *  See terms of license at gnu.org.   *
 *                                     *
 ***************************************/
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;

/**
 * RMIServerInvokerInf
 *
 * @author <a href="mailto:jhaynie@vocalocity.net">Jeff Haynie</a>
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 * @version $Revision:1$
 */
public interface RMIServerInvokerInf extends Remote
{
    /**
     * transport a buffer via RMI
     *
     * @param invocation
     * @return
     * @throws RemoteException
     * @throws IOException
     */
    public Object transport (Object invocation)
        throws RemoteException, IOException;
}
